<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Supply extends Model 
{

    protected $table = 'supply';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'quantity', 'damaged', 'barcode', 'description_en', 'description_ar');

    public function countries()
    {
        return $this->belongsToMany('Country', 'supply_country', 'supply_id', 'country_id');
    }

}