<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserMeta extends Model 
{

    protected $table = 'user_meta';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'player_id', 'user_id');

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function mall()
    {
        return $this->belongsTo('Mall', 'mall_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}