<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientOrderTable extends Migration {

	public function up()
	{
		Schema::create('client_order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->double('total')->nullable();
			$table->enum('payment_method', array('cod', 'cc'))->nullable();
			$table->enum('status', array('processing', 'delivered', 'cancelled'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client_order');
	}
}