<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChatsTable extends Migration {

	public function up()
	{
		Schema::create('chats', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_from')->unsigned();
			$table->integer('user_to')->unsigned();
			$table->text('message');
			$table->tinyInteger('read')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('chats');
	}
}