<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModuleProblemUserAttemptedTable extends Migration {

	public function up()
	{
		Schema::create('module_problem_user_attempted', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('module_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('problem_id')->unsigned();
			$table->decimal('grade', 8,2);
			$table->timestamp('start_date');
			$table->timestamp('end_date');
			$table->string('feedback', 500);
			$table->tinyInteger('running_code')->default('0');
			$table->timestamps();
			$table->text('feedback_html');
			$table->text('code');
			$table->text('errors');
			$table->text('response');
			$table->decimal('execution_time', 8,2);
		});
	}

	public function down()
	{
		Schema::drop('module_problem_user_attempted');
	}
}