<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttacksTable extends Migration {

	public function up()
	{
		Schema::create('attacks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('charid');
			$table->integer('gameid')->default('0');
			$table->string('description', 450);
			$table->string('inputs', 450);
			$table->integer('links_to');
			$table->integer('links_from');
			$table->integer('movetype');
		});
	}

	public function down()
	{
		Schema::drop('attacks');
	}
}