<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Member extends Model 
{

    protected $table = 'members';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function addresses()
    {
        return $this->hasMany('App\MemberAddress', 'member_id');
    }

    public function orders()
    {
        return $this->hasMany('App\Order', 'member_id');
    }

    public function wishlists()
    {
        return $this->hasMany('App\ProductWishlist', 'member_id');
    }

}