<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Member extends Eloquent {

	protected $table = 'members';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function addresses()
	{
		return $this->hasMany('App\MemberAddress', 'member_id');
	}

	public function orders()
	{
		return $this->hasMany('App\Order', 'member_id');
	}

	public function wishlists()
	{
		return $this->hasMany('App\ProductWishlist', 'member_id');
	}

}