<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 255)->unique()->nullable();
			$table->integer('category_id')->unsigned()->index();
			$table->string('name', 150)->index();
			$table->string('code', 150)->nullable()->index();
			$table->string('short_description', 255)->index();
			$table->text('long_description')->nullable();
			$table->tinyInteger('featured')->default('0');
			$table->tinyInteger('rating')->default('0');
			$table->integer('count_views')->default('0');
			$table->integer('count_sales')->default('0');
			$table->tinyInteger('active')->index()->default('1');
			$table->integer('option_parent_type_id')->unsigned()->nullable()->index();
			$table->string('meta_title', 150)->nullable();
			$table->string('meta_description', 255)->nullable();
			$table->string('meta_image', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}