<?php

namespace App;

class Document extends Eloquent {

	protected $table = 'documents';
	public $timestamps = true;
	protected $fillable = array('user_id', 'asset_id', 'title', 'description', 'filename', 'link_url', 'file_category_id');

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function file_category()
	{
		return $this->belongsTo('FileCategory');
	}

	public function asset()
	{
		return $this->belongsTo('App\Asset', 'asset_id');
	}

}