<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'username', 'email', 'password', 'remember_token');

	public function role()
	{
		return $this->belongsToMany('Role');
	}

	public function article()
	{
		return $this->hasMany('Article');
	}

	public function file()
	{
		return $this->hasMany('Document');
	}

	public function headline()
	{
		return $this->hasMany('Headline');
	}

	public function address_book()
	{
		return $this->hasMany('AddressBook');
	}

	public function asset()
	{
		return $this->hasMany('App\Asset');
	}

	public function log_asset()
	{
		return $this->hasMany('App\LogAsset');
	}

}