<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Image extends Model 
{

    protected $table = 'images';
    public $timestamps = true;
    protected $fillable = array('article_id', 'title', 'image_url', 'asset_id', 'image_category_id', 'ruangan_id', 'tanggal', 'keterangan');

    public function article()
    {
        return $this->belongsTo('Article');
    }

    public function asset()
    {
        return $this->belongsTo('App\Asset', 'asset_id');
    }

    public function category()
    {
        return $this->belongsTo('App\ImageCategory', 'image_category_id');
    }

}