<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LogAsset extends Model 
{

    protected $table = 'log_assets';
    public $timestamps = true;
    protected $fillable = array('asset_id', 'log_detail_id', 'user_id', 'satker_id', 'new_satker_id');

    public function log_detail()
    {
        return $this->belongsTo('App\LogDetail', 'log_detail_id');
    }

    public function asset()
    {
        return $this->belongsTo('App\Asset', 'asset_id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'user_id');
    }

    public function satker()
    {
        return $this->belongsTo('App\Satker', 'satker_id');
    }

    public function satker_baru()
    {
        return $this->belongsTo('App\Satker', 'new_satker_id');
    }

}