<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('reservation_id');
			$table->string('addressLine');
			$table->string('city');
			$table->char('countryCode');
			$table->string('email');
			$table->string('name');
			$table->string('phone', 255);
			$table->char('zip', 5);
			$table->string('responseCode', 255);
			$table->string('responseMessage', 255);
			$table->char('responseStatus');
			$table->datetime('transactionTime');
			$table->string('transactionReference', 255);
			$table->char('cartCurrency', 5);
			$table->string('payResponseReturn', 255);
			$table->char('isPending', 5);
			$table->char('isOnHold');
			$table->char('cardScheme', 10);
			$table->char('cardType', 10);
			$table->text('paymentDescription');
			$table->char('isSuccess', 5);
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}