<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseStaffTable extends Migration {

	public function up()
	{
		Schema::create('house_staff', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->string('type')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('phone')->nullable();
			$table->string('email')->nullable();
			$table->date('join_date')->nullable();
			$table->text('biography_en')->nullable();
			$table->text('biography_ar')->nullable();
			$table->text('details_en')->nullable();
			$table->text('details_ar')->nullable();
			$table->string('status')->nullable();
			$table->date('departure_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house_staff');
	}
}