<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHouseSpecialNeedTable extends Migration {

	public function up()
	{
		Schema::create('house_special_need', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('house_id')->nullable();
			$table->integer('orphan_id')->nullable();
			$table->integer('donation_category_id')->nullable();
			$table->string('title_en')->nullable();
			$table->string('title_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->date('requested_date')->nullable();
			$table->date('fulfilled_date')->nullable();
			$table->string('status', 50)->nullable();
			$table->double('expected_price')->nullable();
			$table->date('due_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('house_special_need');
	}
}