<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceProviderTable extends Migration {

	public function up()
	{
		Schema::create('service_provider', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->string('provider_location', 100)->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('email', 100)->nullable();
			$table->string('mobile', 15)->nullable();
			$table->string('phone', 15)->nullable();
			$table->string('hotline', 15)->nullable();
			$table->text('additional_info_en')->nullable();
			$table->text('additional_info_ar')->nullable();
			$table->string('responsible_person', 100)->nullable();
			$table->integer('service_category_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service_provider');
	}
}