<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('family_id')->unsigned()->nullable();
			$table->integer('driver_id')->unsigned()->nullable();
			$table->integer('address_id')->unsigned()->nullable();
			$table->enum('payment_types', array('cash', 'wallet'))->nullable();
			$table->enum('order_time', array('now', 'later'))->nullable();
			$table->string('date', 191)->nullable();
			$table->string('time', 191)->nullable();
			$table->string('total_price', 191)->nullable();
			$table->enum('status', array('new', 'in_progress', 'finish', 'cancel', 'in_delivery'))->nullable();
			$table->string('order_code', 191)->nullable();
			$table->string('cart_total', 191)->nullable();
			$table->string('tax', 191)->nullable();
			$table->string('delivery_cost', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}