<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartsTable extends Migration {

	public function up()
	{
		Schema::create('carts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('family_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('count')->default('0');
			$table->string('price', 191)->nullable()->default('0');
			$table->enum('status', array('car', 'order'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('carts');
	}
}