<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLookupPostTypeTable extends Migration {

	public function up()
	{
		Schema::create('lookup_post_type', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->unique();
			$table->string('display', 255);
			$table->string('description', 255)->nullable();
			$table->integer('post_type_id')->unique()->unsigned();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lookup_post_type');
	}
}