<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('post_type_id')->references('post_type_id')->on('lookup_post_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lookup_post_type', function(Blueprint $table) {
			$table->foreign('post_type_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_type_attributes_join', function(Blueprint $table) {
			$table->foreign('post_type_id')->references('post_type_id')->on('lookup_post_type')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_type_attributes_join', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_attribute_value', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('post_attribute_value', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attributes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_categories_join', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_categories_join', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_tags_join', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_tags_join', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_post_type_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_created_by_foreign');
		});
		Schema::table('lookup_post_type', function(Blueprint $table) {
			$table->dropForeign('lookup_post_type_post_type_id_foreign');
		});
		Schema::table('posts_type_attributes_join', function(Blueprint $table) {
			$table->dropForeign('posts_type_attributes_join_post_type_id_foreign');
		});
		Schema::table('posts_type_attributes_join', function(Blueprint $table) {
			$table->dropForeign('posts_type_attributes_join_attribute_id_foreign');
		});
		Schema::table('post_attribute_value', function(Blueprint $table) {
			$table->dropForeign('post_attribute_value_post_id_foreign');
		});
		Schema::table('post_attribute_value', function(Blueprint $table) {
			$table->dropForeign('post_attribute_value_attribute_id_foreign');
		});
		Schema::table('posts_categories_join', function(Blueprint $table) {
			$table->dropForeign('posts_categories_join_post_id_foreign');
		});
		Schema::table('posts_categories_join', function(Blueprint $table) {
			$table->dropForeign('posts_categories_join_category_id_foreign');
		});
		Schema::table('posts_tags_join', function(Blueprint $table) {
			$table->dropForeign('posts_tags_join_post_id_foreign');
		});
		Schema::table('posts_tags_join', function(Blueprint $table) {
			$table->dropForeign('posts_tags_join_tag_id_foreign');
		});
	}
}