<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCheckerRequestsTable extends Migration {

	public function up()
	{
		Schema::create('checker_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('status')->nullable();
			$table->string('request_code', 4)->nullable();
			$table->string('employee_national_id', 24)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('checker_requests');
	}
}