<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationLogsTable extends Migration {

	public function up()
	{
		Schema::create('integration_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable();
			$table->json('request_body')->nullable();
			$table->json('request_response')->nullable();
			$table->string('url', 255)->nullable();
			$table->string('method', 10)->nullable();
			$table->string('status_code', 4)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('integration_logs');
	}
}