<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 100);
			$table->string('type', 100);
			$table->longText('value');
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}