<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProvidersTable extends Migration {

	public function up()
	{
		Schema::create('providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('category', 100);
			$table->string('logo', 100)->nullable();
			$table->integer('hot_line')->unique();
			$table->integer('branches_count');
			$table->integer('max_installments');
			$table->integer('profit_rate');
			$table->string('facebook_url', 100)->nullable();
			$table->string('linkedin_url', 100)->nullable();
			$table->string('whatsapp_number', 100)->nullable();
			$table->string('twitter_url', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('providers');
	}
}