<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Appreciation extends Model 
{

    protected $table = 'appreciations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('teacher_id', 'student_id', 'subject_id', 'subject', 'message', 'images');
    protected $visible = array('teacher_id', 'student_id', 'subject_id', 'subject', 'message', 'images');

    public function teacher()
    {
        return $this->belongsToMany('App\Teacher');
    }

    public function student()
    {
        return $this->belongsToMany('App\Student');
    }

}