<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class School extends Model 
{

    protected $table = 'schools';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'logo', 'description', 'contact_no', 'email', 'owner', 'address', 'registration_no', 'pincode');
    protected $visible = array('name', 'logo');

    public function group()
    {
        return $this->hasMany('App\Group');
    }

    public function teacher()
    {
        return $this->hasMany('App\Teacher');
    }

}