<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Teacher extends Model 
{

    protected $table = 'teachers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('school_id', 'name', 'middle_name', 'last_name', 'username', 'password', 'email', 'contact_no', 'description', 'active');
    protected $visible = array('school_id', 'name', 'username', 'password');

    public function group()
    {
        return $this->hasMany('App\Group');
    }

    public function appreciation()
    {
        return $this->hasMany('App\Appreciation');
    }

    public function school()
    {
        return $this->belongsTo('App\School');
    }

    public function notification()
    {
        return $this->hasMany('App\Notification', 'notificatioon_id');
    }

    public function groupSubjectTeacher()
    {
        return $this->hasMany('App\GroupSubjectTeacher');
    }

    public function parentTeacherChat()
    {
        return $this->hasMany('App\ParentTeacherChat');
    }

}