<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Jobs extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function JobOffers()
    {
        return $this->hasMany('JobOffers');
    }

    public function JobStatus()
    {
        return $this->hasOne('JobStatuses');
    }

    public function Manager()
    {
        return $this->hasOne('Users');
    }

    public function Developer()
    {
        return $this->hasOne('Users');
    }

    public function Skills()
    {
        return $this->belongsToMany('JobSkills');
    }

}