<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function skills()
    {
        return $this->belongsToMany('UserSkills');
    }

    public function role()
    {
        return $this->hasOne('UserRoles');
    }

}