<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Village extends Eloquent {

	protected $table = 'villages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function requests()
	{
		return $this->hasMany('Request');
	}

	public function commune()
	{
		return $this->belongsTo('Commune');
	}

}