<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title_en');
			$table->string('title_ar');
			$table->string('excerpt_en');
			$table->string('excerpt_ar');
			$table->string('body_en');
			$table->string('body_ar');
			$table->timestamps();
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}