<?php

namespace App\Models;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;
	protected $fillable = array('name_en', 'name_ar', 'excerpt_en', 'excerpt_ar', 'description_en', 'description_ar', 'activation', 'is_featured');

	public function photos()
	{
		return $this->morphMany('App\Models\Photo');
	}

	public function tags()
	{
		return $this->morphToMany('App\Models\Tag');
	}

}