<?php

namespace App\Models;

class Tag extends Eloquent {

	protected $table = 'tags';
	public $timestamps = true;
	protected $fillable = array('title_en', 'title_ar');

	public function posts()
	{
		return $this->morphedByMany('App\Models\Post');
	}

	public function sliders()
	{
		return $this->morphedByMany('App\Models\Slider');
	}

	public function pages()
	{
		return $this->morphedByMany('App\Models\Page');
	}

	public function jobs()
	{
		return $this->morphedByMany('App\Models\Job');
	}

	public function categories()
	{
		return $this->morphedByMany('App\Models\Category');
	}

	public function products()
	{
		return $this->morphedByMany('App\Models\Product');
	}

	public function customers()
	{
		return $this->morphedByMany('App\Models\Customer');
	}

	public function projects()
	{
		return $this->morphedByMany('App\Models\Project');
	}

	public function services()
	{
		return $this->morphedByMany('App\Models\Service');
	}

}