<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname', 10);
			$table->string('lastname', 20);
			$table->string('username', 20);
			$table->string('email', 50);
			$table->string('password', 60);
			$table->date('birthday')->nullable();
			$table->string('address', 100);
			$table->string('del_flag', 1)->default('N');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}