<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 30);
			$table->string('owner', 20);
			$table->string('address', 100);
			$table->string('owner_address', 100)->nullable();
			$table->string('geolocations', 100)->nullable();
			$table->integer('res_category_id');
			$table->integer('evaluation_id');
			$table->string('del_flag', 1)->default('N');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}