<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInfrastructuresTable extends Migration {

	public function up()
	{
		Schema::create('infrastructures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('code', 255);
			$table->string('name', 255);
			$table->string('cdn_url', 255);
			$table->string('load_balancer_url', 255);
			$table->string('db_core_host', 255);
			$table->string('db_app_host', 255);
			$table->integer('country_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('infrastructures');
	}
}