<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Person extends Eloquent {

	protected $table = 'persons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contacts()
	{
		return $this->hasMany('Contact');
	}

	public function address()
	{
		return $this->belongsTo('Address');
	}

}