<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyOption extends Model 
{

    protected $table = 'companies_options';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function company()
    {
        return $this->belongsTo('Company');
    }

    public function application()
    {
        return $this->belongsTo('Application');
    }

}