<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function contacts()
    {
        return $this->hasMany('Contact');
    }

    public function address()
    {
        return $this->belongsTo('Address');
    }

    public function application()
    {
        return $this->morphToMany('ApplicationCompany');
    }

    public function infrastucture()
    {
        return $this->belongsTo('Infrastructure');
    }

}