<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->index();
			$table->string('address', 100)->nullable();
			$table->string('address2', 100)->nullable();
			$table->string('address3', 100)->nullable();
			$table->string('city', 100)->nullable();
			$table->string('zipcode', 100)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->string('phone', 100)->nullable();
			$table->string('fax', 100)->nullable();
			$table->string('website', 255)->nullable();
			$table->string('picture', 255)->nullable();
			$table->integer('addressable_id');
			$table->string('addressable_type', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}