<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApisTable extends Migration {

	public function up()
	{
		Schema::create('apis', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('application_id')->unsigned()->nullable();
			$table->string('name', 255)->index();
			$table->text('description')->nullable();
			$table->text('fields');
			$table->tinyInteger('status')->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('apis');
	}
}