<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccBalanceSheet extends Model 
{

    protected $table = 'acc_balance_sheet';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'parent_id', 'user_id');

    public function parent()
    {
        return $this->belongsTo('AccBalanceSheet', 'parent_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function balance_sheet_accounts()
    {
        return $this->hasMany('AccBalanceSheetAccount', 'balance_sheet_id');
    }

    public function control_accounts()
    {
        return $this->hasMany('AccControlAccount', 'balance_sheet_id');
    }

    public function subaccounts()
    {
        return $this->hasMany('AccCapitalSubAccount', 'balance_sheet_id');
    }

    public function capital_accounts()
    {
        return $this->hasMany('AccCapitalAccount', 'balance_sheet_id');
    }

}