<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccBankStatement extends Model 
{

    protected $table = 'acc_bank_statement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('bank_account_id', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function bank_account()
    {
        return $this->belongsTo('AccBankAccount', 'bank_account_id');
    }

}