<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccCashFlow extends Model 
{

    protected $table = 'acc_cash_flow';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cash_flow_type_id', 'name');

    public function cash_flow_type()
    {
        return $this->belongsTo('AccCashFlowType', 'cash_flow_type_id');
    }

}