<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccControlAccount extends Model 
{

    protected $table = 'acc_control_account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'name', 'code', 'balance_sheet_id', 'control_type_id', 'cash_flow_type_id', 'cash_flow_id', 'status', 'account_category_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function balance_sheet()
    {
        return $this->belongsTo('AccBalanceSheet', 'balance_sheet_id');
    }

    public function control_type()
    {
        return $this->belongsTo('AccControlType', 'control_type_id');
    }

    public function special_accounts()
    {
        return $this->hasMany('AccSpecialAccount', 'control_account_id');
    }

    public function capital_accounts()
    {
        return $this->hasMany('AccCapitalAccount', 'control_account_id');
    }

    public function capital_subaccounts()
    {
        return $this->hasMany('AccCapitalSubAccount', 'control_account_id');
    }

    public function account_category()
    {
        return $this->belongsTo('AccAccountCategory', 'account_category_id');
    }

}