<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccDeliveryNote extends Model 
{

    protected $table = 'acc_delivery_note';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'reference', 'sales_order_id', 'sales_invoice_id', 'customer_id', 'inventory_id', 'user_id', 'description', 'quantity', 'delivery_address', 'title', 'footer_id');

    public function customer()
    {
        return $this->belongsTo('AccCustomer', 'customer_id');
    }

    public function sales_order()
    {
        return $this->belongsTo('AccSalesOrder', 'sales_order_id');
    }

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function items()
    {
        return $this->hasMany('AccItem', 'delivery_note_id');
    }

    public function footer()
    {
        return $this->belongsTo('AccFooter', 'footer_id');
    }

}