<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccDivision extends Model 
{

    protected $table = 'acc_division';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_id', 'status');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function places()
    {
        return $this->belongsToMany('AccPlace', 'acc_division_place', 'division_id', 'place_id');
    }

}