<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccFooter extends Model 
{

    protected $table = 'acc_footer';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'content', 'code_editor', 'footer_category_id', 'status');

    public function footer_category()
    {
        return $this->belongsTo('AccFooterCategory', 'footer_category_id');
    }

}