<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccItem extends Model 
{

    protected $table = 'acc_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'type', 'name', 'receipt_id', 'balance_sheet_account_id', 'profit_loss_account_id', 'show_quantity', 'quantity', 'unit_price', 'total', 'division_id', 'amount', 'description', 'show_discount', 'discount_type', 'discount', 'cost_goods_type', 'cost_goods_price', 'place_id', 'division_place_id', 'expense_claim_id', 'sales_quote_id', 'sales_order_id', 'sales_invoice_id', 'inventory_item_id', 'payment_id', 'request_for_quotation', 'purchase_quote_id', 'purchase_order_id', 'purchase_invoice_id', 'debit_note_id', 'goods_receipt_id', 'project_id', 'inventory_id', 'journal_entry_id', 'journal_depit', 'journal_credit', 'capitalsub_account_id', 'capital_account_id', 'control_account_id', 'special_account_id', 'forecast_id', 'recurring_transaction_id', 'bank_rule_id', 'non_inventory_item_id', 'inventory_kit_id', 'tax_code_id', 'employee_id', 'tax_amount', 'sales_price', 'show_price_unit', 'show_tax_amount', 'total_after_tax', 'tax_inclusive', 'account_type');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function receipt()
    {
        return $this->belongsTo('AccReceipt', 'receipt_id');
    }

    public function profit_loss_account()
    {
        return $this->belongsTo('AccProfitLossAccount', 'profit_loss_account_id');
    }

    public function division()
    {
        return $this->belongsTo('AccDivision', 'division_id');
    }

    public function sales_quote()
    {
        return $this->belongsTo('AccSalesQuote', 'sales_quote_id');
    }

    public function sales_order()
    {
        return $this->belongsTo('AccSalesOrder', 'sales_order_id');
    }

    public function inventory_item()
    {
        return $this->belongsTo('AccInventoryItem', 'inventory_item_id');
    }

    public function sales_invoice()
    {
        return $this->belongsTo('AccSalesInvoice', 'sales_invoice_id');
    }

    public function balance_sheet_account()
    {
        return $this->belongsTo('AccBalanceSheetAccount', 'balance_sheet_account_id');
    }

    public function place()
    {
        return $this->belongsTo('AccPlace', 'place_id');
    }

    public function division_place()
    {
        return $this->belongsTo('AccDivisionPlace', 'division_place_id');
    }

    public function expense_claim()
    {
        return $this->belongsTo('AccExpenseClaim', 'expense_claim_id');
    }

    public function payment()
    {
        return $this->belongsTo('AccPayment', 'payment_id');
    }

    public function purchase_quote()
    {
        return $this->belongsTo('AccPurchaseQuote', 'purchase_quote_id');
    }

    public function purchase_order()
    {
        return $this->belongsTo('AccPurchaseOrder', 'purchase_order_id');
    }

    public function purchase_invoice()
    {
        return $this->belongsTo('AccPurchaseInvoice', 'purchase_invoice_id');
    }

    public function debit_note()
    {
        return $this->belongsTo('AccDebitNote', 'debit_note_id');
    }

    public function goods_receipt()
    {
        return $this->belongsTo('AccGoodsReceipt', 'goods_receipt_id');
    }

    public function project()
    {
        return $this->belongsTo('AccProject', 'project_id');
    }

    public function inventory()
    {
        return $this->belongsTo('AccInventory', 'inventory_id');
    }

    public function journal_entry()
    {
        return $this->belongsTo('AccJournalEntry', 'journal_entry_id');
    }

    public function capitalsub_account()
    {
        return $this->belongsTo('AccCapitalSubAccount', 'capitalsub_account_id');
    }

    public function capital_account()
    {
        return $this->belongsTo('AccCapitalAccount', 'capital_account_id');
    }

    public function control_account()
    {
        return $this->belongsTo('AccControlAccount', 'control_account_id');
    }

    public function special_account()
    {
        return $this->belongsTo('AccSpecialAccount', 'special_account_id');
    }

    public function forecast()
    {
        return $this->belongsTo('AccForecast', 'forecast_id');
    }

    public function recurring_transaction()
    {
        return $this->belongsTo('AccRecurringTransaction', 'recurring_transaction_id');
    }

    public function bank_rule()
    {
        return $this->belongsTo('AccBankRule', 'bank_rule_id');
    }

    public function non_inventory_item()
    {
        return $this->belongsTo('AccNonInventoryItem', 'non_inventory_item_id');
    }

    public function inventory_kit()
    {
        return $this->belongsTo('AccInventoryKit', 'inventory_kit_id');
    }

    public function tax_code()
    {
        return $this->belongsTo('AccTaxCode', 'tac_code_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

}